const serviceUrl = 'http://116.196.87.227';

const _state_ = {
    debug: false,
    cookie: '',
    loginInfo: {}
}

var BackgroundCache = {
    requestUrl: {}
};

// 序列化参数
function serializeData(obj, prefix = '') {
    const params = new URLSearchParams();
    
    function encode(key, value) {
        const fullKey = prefix ? `${prefix}[${key}]` : key;
        
        if (typeof value === 'object' && value !== null) {
            if (Array.isArray(value)) {
                value.forEach((item, index) => encode(index, item));
            } else {
                Object.entries(value).forEach(([k, v]) => encode(k, v));
            }
        } else {
            params.append(fullKey, value);
        }
    }
    
    Object.entries(obj).forEach(([key, value]) => encode(key, value));
    return params;
}

const _action_ = {
    // 暂停
    sleep: function(milliseconds) {
        return new Promise(resolve => setTimeout(resolve, milliseconds));
    },
    // 检查是否已打开
    requestUrlState: {
        find: function(val, key) {
            for(var bkey in BackgroundCache) {
                if(BackgroundCache[bkey][key] == val) {
                    return bkey;
                }
            }
            
            return false;
        }
    },
    sendResponseOprate: function(sendResponse, data = '', code = 200, msgId = null) {
        sendResponse && sendResponse({
            msgType: 'fromBackground',
            msgId: msgId || (new Date()).getTime(),
            data: data,
            type: code == 200 ? 'success' : 'error',
            code: code
        });
    },
    setBgCache: function(key, value, sendResponse) {
        BackgroundCache[key] = value;

        _action_.sendResponseOprate(sendResponse, "设置缓存成功");
    },
    getBgCache: function(key, sendResponse) {
        if(BackgroundCache.hasOwnProperty(key)) {
            _action_.sendResponseOprate(sendResponse, BackgroundCache[key]);
        } else {
            _action_.sendResponseOprate(sendResponse, "获取缓存失败", 0);
        }
    },
    getTabContent: function(params, sendResponse) {
        chrome.tabs.create({ url: params.url, active: false }, (newTab) => {
            chrome.tabs.get(newTab.id, (tab) => {
                if (chrome.runtime.lastError) {
                    return false;
                }

                if(params.type == 'img') {
                    chrome.scripting.executeScript({
                        target: { tabId: newTab.id }, // 目标选项卡ID
                        func: () => {
                            var imgEle = document.getElementsByTagName('img');
                            var imgList = [];
                            for(var i = 0; i < imgEle.length; i++) {
                                if(imgEle[i].dataset.src) {
                                    imgList.push(imgEle[i].dataset.src);
                                }
                            }

                            return imgList;
                        }
                    }, async (results) => {
                        if (chrome.runtime.lastError) {
                            return ;
                        }
                        _action_.sendResponseOprate(sendResponse, results[0].result);

                        setTimeout(function() {
                            chrome.tabs.remove(newTab.id);
                        }, 3000);
                    });
                }
            });
        });
    },
    toCjzsTab: function(sendResponse) {
        var tabId = _state_.loginInfo.tabId;

        chrome.tabs.get(tabId, (tab) => {
            if (chrome.runtime.lastError) {
                return false;
            }

            chrome.tabs.update(tabId, { active: true }, (updatedTab) => {
                if (chrome.runtime.lastError) {
                    return;
                }
                
                return true;
            });

            
        });
    },
    formatRequestUrl: function(url){
        return serviceUrl + url;
    },
    insertCSS: function(tabId, details) {
        chrome.tabs.insertCSS(tabId, details);
    },
    executeScript: function(tabId, details) {
        chrome.scripting.executeScript({
          target: { tabId: tabId },
          files: [ _action_.formatRequestUrl(details.file) ]
        }, (results) => {
        });
    },
    executeRemoteScript: function(tabId, url, allFrames) {
        var url = _action_.formatRequestUrl(url);

        _action_.ajax(url, null, 'GET', null, function(data) {
            var details = {code: data, allFrames: allFrames || false};
            _action_.executeScript(tabId, details);
        })
    },
    loadExternalScript: function(url) {
        return new Promise((resolve, reject) => {
            const script = document.createElement('script');
            script.src = url;
            script.onload = resolve;
            script.onerror = reject;
            document.head.appendChild(script);
        });
    },
    login: function(tab, request, sendResponse) {
        _action_.getCookie(tab.url, function (ret) {
            if(ret.code == 200 && ret.data && ret.data.length > 0) {
                var url = serviceUrl + '/external/api/parse_vender_info?session_key=' + ret.data;
                _action_.ajax(url, null, 'GET', null, function(ret2) {
                    if(ret2.code == 200 && ret2.data.venderId) {
                        _state_.loginInfo.venderId = ret2.data.venderId;
                        _state_.loginInfo.shopName = ret2.data.shopName;

                        if(request.type && request.type == 'self') {
                            _state_.loginInfo.tabId = tab.id;
                            _state_.loginInfo.saveFetchUrl = request.saveFetchUrl
                        }
                        
                        BackgroundCache.loginInfo = _state_.loginInfo;
                        _action_.sendResponseOprate(sendResponse, BackgroundCache.loginInfo, 200);
                    } else {
                        _action_.sendResponseOprate(sendResponse, '未登录', 0);
                    }
                });
            }
        });
    },
    getCookie: function(url, sendResponse) {
        chrome.cookies.getAll({url: url}, function (cookies) {
            var values = [];
            for(var i = 0; i < cookies.length; i++){
                cookies[i].name && values.push(cookies[i].name + '=' + cookies[i].value);
            }

            _state_.cookie = values.join('; ');

            _action_.sendResponseOprate(sendResponse, _state_.cookie, 200);
        });
    },
    ajax: function(url, params, method = 'GET', headers = null, sendResponse = null) {
        if(!headers) {
            headers = {
                'Content-Type': 'application/json'
            };
        }

        var option = {
            method: method || 'GET',
            headers: headers
        }

        if(params) {
            option.body = JSON.stringify(params);
        }

        fetch(url, option).then(response => {
            var responseData = null;
            try{
                responseData = response.json();
            } catch {
                responseData = responseData.text();
            }
            return responseData;
        }).then(res => {
            _action_.sendResponseOprate(sendResponse, res, 200);
        }).catch(error => {
            _action_.sendResponseOprate(sendResponse, error, 0);
        });
    },
    openNewTab: async function(url, urlTabId, goodId, field, reCount = 2) {
        var _tmp_url = new URL(url);
        var params = new URLSearchParams(_tmp_url.searchParams);
        var callbackName = params.get('callback');

        if(!goodId || _action_.requestUrlState.find(url, 'url') !== false) {
            return false;
        }

        if(!BackgroundCache.hasOwnProperty('requestUrl_' + goodId)) {
            BackgroundCache['requestUrl_' + goodId] = {
                tabId: urlTabId,
                url: url,
                sku: null,
                detail: null
            };
        } else if (BackgroundCache['requestUrl_' + goodId].detail) {
            return false;
        }
        
        await _action_.sleep(1000);

        chrome.tabs.create({ url: url, active: false }, (newTab) => {
            chrome.tabs.get(newTab.id, (tab) => {
                if (chrome.runtime.lastError) {
                    return false;
                }

                chrome.scripting.executeScript({
                    target: { tabId: newTab.id },
                    func: () => {
                        return document.body.innerText.trim();
                    }
                }, async (results) => {
                    if (chrome.runtime.lastError) {
                        return ;
                    }

                    var toReLoad = true;
                    var tabContent = results[0].result;

                    if(tabContent.indexOf(callbackName) === 0) {
                        tabContent = tabContent.substring(callbackName.length + 1, tabContent.length -1);
                        tabContent = JSON.parse(tabContent);

                        if(tabContent && tabContent.api && tabContent.ret && tabContent.ret.length > 0 && tabContent.ret[0].includes('SUCCESS')) {
                            BackgroundCache['requestUrl_' + goodId][field] = tabContent.data;
                            toReLoad = false;
                        } 
                    }

                    setTimeout(function() {
                        chrome.tabs.remove(newTab.id);
                    }, 3000);
                    
                    if(toReLoad && reCount >= 0) {
                        reCount--;
                        await _action_.sleep(2000);
                        _action_.openNewTab(url, urlTabId, goodId, field, reCount);
                    }
                });
            });
        });
    }
}

chrome.runtime.onMessage.addListener(function(request, sender, sendResponse) {
    if(request.action) {
        switch(request.action) {
            case 'login':
                _action_.login(sender.tab, request, sendResponse);
                break;
            case 'checkLoginStatus':
                if(_state_.loginInfo && Object.keys(_state_.loginInfo).length > 0) {
                    _action_.sendResponseOprate(sendResponse, _state_.loginInfo, 200);
                } else {
                    _action_.sendResponseOprate(sendResponse, '未登录', 0);
                }
                break;
            case 'setBgCache':
                _action_.setBgCache(request.key, request.value, sendResponse);
                break;
            case 'getBgCache':
                _action_.getBgCache(request.key, sendResponse);
                break;
            case 'OPEN_TAB_AND_GET_CONTENT':
                _action_.getTabContent(request, sendResponse);
                break;
            case 'SAVE_CRAWLED_ITEM_ID':
                _action_.toCjzsTab(sendResponse);
                break;
            case 'setRequestUrl':
                if(BackgroundCache.hasOwnProperty('requestUrl_' + request.goodId)) {
                    var field = null;
                    if(request.api == 'mtop.taobao.rate.detaillist.get') {
                        field = 'sku';
                    } else if(request.api == 'mtop.taobao.pcdetail.data.get') {
                        field = 'detail';
                    }

                    if(field) {
                        BackgroundCache['requestUrl_' + request.goodId][field] = request.value;
                    }
                }
                break;
            case 'getCookie':
                _action_.getCookie(sender.tab.url, sendResponse);
                break;
            case 'ajax':
                if(!request.data) {
                    return _action_.sendResponseOprate(sendResponse, '参数错误', 0);
                }
                var url = request.data.url;
                var params = request.data.params;
                var method = request.data.method || 'GET';
                var headers = request.data.headers || null;

                _action_.ajax(url, params, method, headers, sendResponse);
                break;
            case 'executeRemoteScript':
                _action_.executeRemoteScript(sender.tab.id, request.url, request.allFrames);
                break;
            case 'insertCSS':
                _action_.insertCSS(sender.tab.id, request.details);
                break;
            case 'executeScript':
                _action_.executeScript(sender.tab.id, request.details);
                break;
            case 'loadExternalScript':
                _action_.loadExternalScript(request.url);
                break;
        }
        
        return true;
    } else {
        _action_.sendResponseOprate(sendResponse, '未找到活动标签', 0);
    }
});


const onBeforeRequestRequestIds = new Set();
chrome.webRequest.onBeforeRequest.addListener(
    async (details) => {
        if (onBeforeRequestRequestIds.has(details.requestId)) {
            return false;
        }

        onBeforeRequestRequestIds.add(details.requestId);

        if (details.url.includes("api.m.jd.com/description/channel")) {
            var _tmp_url = new URL(details.url);
            var params = new URLSearchParams(_tmp_url.searchParams);
            var paramValue = params.get('mainSkuId');
            BackgroundCache[paramValue] = details.url;

            chrome.tabs.query({ active: true, currentWindow: true }, (tabs) => {
                const activeTab = tabs[0];
                if (!activeTab) {
                    return;
                }

                chrome.tabs.sendMessage(
                    activeTab.id,
                    { 
                        msgType: 'toUtils',
                        msgId: (new Date()).getTime(),
                        data: { type: 'JdDescUrl', url: details.url, skuId: paramValue },
                        type: 'success',
                        code: 200
                    },
                    (response) => {
                        if (chrome.runtime.lastError) {
                            return;
                        }
                    }
                );
            });
        } else if (details.url.includes("mtop.taobao.pcdetail.data.get")) {
            chrome.tabs.get(details.tabId, (tab) => {
                if (chrome.runtime.lastError) {
                    return;
                }

                chrome.scripting.executeScript({
                    target: { tabId: details.tabId },
                    func: () => {
                        return window.location.href;
                    }
                }, (results) => {
                    if (chrome.runtime.lastError) {
                        return;
                    }

                    if(results && results.length > 0) {
                        var _tmp_url = new URL(results[0].result);
                        var params2 = new URLSearchParams(_tmp_url.searchParams);
                        var goodId = params2.get('id');


                        _action_.openNewTab(details.url, details.tabId, goodId, 'detail');
                    }
                    
                });
            });
        }

        setTimeout(() => {
            onBeforeRequestRequestIds.delete(details.requestId);
        }, 30000);
    },
    { urls: ["<all_urls>"] },
    []
);